

#include "InterfaceLoadSave.h"
#include "ifacegen.h"
#include "filedlg.h"
#include "OnScreenDisplay.h"
#include "filetool.h"

#include "directx\ds.h"
#include "../zipsupport/UnzipApp.h"


#include "../../cpc/diskimage/diskimg.h"
#include "../../special/win/messages.h"
#include "../../cpc/fdd.h"
#include "../../cpc/tzx.h"
#include "../../cpc/cpc.h"
#include "../../cpc/amsdos.h"
#include "../../cpc/autotype.h"
#include "../../cpc/sampload.h"
#include "../../cpc/audio.h"
#include "../../cpc_modified/cheatdb.h"
#include "../../cpc/autorunfile.h"
#include "../../cpc/snapshot.h"
#include "../../cpc/asic.h"
#include "../../cpc/fdi.h"

//************************************************************************************

static TCHAR FilenameBuffer[MAX_PATH];
//const char *sAutoStringTape = "|TAPE\nRUN\"\n\n";
static TCHAR *RomFilename;

void DigiblasterEnable(BOOL b);


const TCHAR *pDiskImageWriteExtensions[]=
{
	_T("dsk"),
	NULL
};

const TCHAR *pDiskImageReadExtensions[]=
{
	_T("dsk"),
	_T("dif"),
	NULL
};

const TCHAR *ZipExtensions[]=
{
	_T("zip"),
	NULL
};

const TCHAR *AllFileExtensions[]=
{
	_T("*"),
	NULL,
};

const TCHAR *TextFileExtensions[]=
{
	_T("txt"),
	NULL,
};

const TCHAR *YM5_Extensions[]=
{
	_T("ym5"),
	NULL
};


const TCHAR *YM3_Extensions[]=
{
	_T("ym3"),
	NULL
};

const TCHAR *Wave_Extensions[]=
{
	_T("wav"),
	NULL
};


const TCHAR *ROM_Extensions[]=
{
	_T("rom"),
	NULL
};

const TCHAR *BAS_Extensions[]=
{
    _T("bas"),
    NULL
};

const TCHAR *BIN_Extensions[]=
{
	_T("bin"),
	NULL
};

const TCHAR *CDT_Extensions[]=
{
	_T("cdt"),
	_T("tzx"),
	_T("wav"),
	_T("voc"),
	_T("csw"),
	NULL
};

const TCHAR *CDTW_Extensions[]=
{
	_T("wav"),
	_T("voc"),
	_T("csw"),
	NULL
};

const TCHAR *CDTT_Extensions[]=
{
	_T("cdt"),
	_T("tzx"),
	NULL
};

const TCHAR *SNA_Extensions[]=
{
	_T("sna"),
	NULL
};

const TCHAR *CPR_Extensions[]=
{
	_T("cpr"),
	NULL
};

const TCHAR *BMP_Extensions[]=
{
	_T("bmp"),
	NULL
};

const TCHAR *POK_Extensions[]=
{
	_T("POK"),
	NULL
};

//**************************************************************************************

/* append a null terminated string */
static TCHAR *AppendString(TCHAR *pPtr, const TCHAR *pDescription)
{
	/* get string length */
	unsigned long length = _tcslen(pDescription);

	/* copy the characters */
	memcpy(pPtr, pDescription, (length*sizeof(TCHAR)));
	pPtr+=length;

	return pPtr;
}

/* append char */
static TCHAR *AppendChar(TCHAR *pPtr, const TCHAR ch)
{
	pPtr[0]=ch;
	pPtr++;

	return pPtr;
}

static TCHAR *AddExtensions(TCHAR *pPtr, const TCHAR **pExtensionList)
{
	char **pCurrentExtension;
	BOOL bFirst;

	/* begin extension list part of description */
	pPtr = AppendString(pPtr,_T(" ("));
	bFirst = TRUE;

	/* complete description */
	pCurrentExtension = (char **)pExtensionList;
	while (*pCurrentExtension!=NULL)
	{
		char *pExtension = *pCurrentExtension;

		/* if there is a extension preceeding, then add a ; symbol */
		if (!bFirst)
		{
			pPtr = AppendChar(pPtr, _T(';'));
		}
		bFirst = FALSE;

		/* add the extension */
		pPtr = AppendString(pPtr, _T("*."));
		pPtr = AppendString(pPtr, pExtension);

		pCurrentExtension++;
	}

	/* end description part */
	pPtr = AppendChar(pPtr,_T(')'));
	pPtr = AppendChar(pPtr,_T('\0'));

	bFirst = TRUE;
	/* now do file type list part */
	pCurrentExtension = (char **)pExtensionList;
	while (*pCurrentExtension!=NULL)
	{
		char *pExtension = *pCurrentExtension;

		/* if there is a extension preceeding, then add a ; symbol */
		if (!bFirst)
		{
			pPtr = AppendChar(pPtr,_T(';'));
		}
		bFirst = FALSE;

		/* add the extension */
		pPtr = AppendString(pPtr, _T("*."));
		pPtr = AppendString(pPtr, pExtension);

		pCurrentExtension++;
	}

	return pPtr;
}

void InitFilenameForFileOpenDlg(const TCHAR *sFilename, TCHAR *sFileOpenDialogFilename)
{
	TCHAR sName[MAX_PATH];
	TCHAR sExt[MAX_PATH];

	if ((sFilename==NULL) || (strlen(sFilename) == 0))
	{
		sFileOpenDialogFilename[0]=_T('\0');
		return;
	}

	_tsplitpath(sFilename, NULL, NULL, sName, sExt);

	_stprintf(sFileOpenDialogFilename,_T("%s.%s"),sFilename,sExt);
}

void SetStringAsPath(TCHAR *ppReplaceString, const TCHAR *sString)
{
	TCHAR sDir[MAX_PATH];
	TCHAR sDrive[MAX_PATH];

	_tsplitpath(sString, sDrive, sDir, NULL, NULL);

	_tcscat(sDrive,sDir);

	strcpy(ppReplaceString,sDrive);
}

//**************************************************************************************

#if 0
enum
{
	PRINTER_OUTPUT_TO_FILE,
	PRINTER_OUTPUT_TO_PRINTER,
	PRINTER_OUTPUT_DO_NOTHING,
	PRINTER_OUTPUT_TO_DIGIBLASTER
};

static HANDLE fhPrinterOutput = INVALID_HANDLE_VALUE;
static int PrinterOutputMethod = PRINTER_OUTPUT_DO_NOTHING;

void	Printer_CloseOutputFile(void)
{
	if (fhPrinterOutput!=INVALID_HANDLE_VALUE)
	{
		CloseHandle(fhPrinterOutput);
		fhPrinterOutput = INVALID_HANDLE_VALUE;
	}
}

void PrinterOutputReset()
{
	PrinterOutputMethod = PRINTER_OUTPUT_DO_NOTHING;
	DigiblasterEnable(FALSE);
}

static void	Printer_OpenOutputFile(TCHAR *pFilename)
{
	fhPrinterOutput = CreateFile(pFilename, GENERIC_WRITE, 0, NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);
}


void PrinterOutputToDigiblaster(void)
{
	Printer_CloseOutputFile();
	PrinterOutputMethod = PRINTER_OUTPUT_TO_DIGIBLASTER;
	DigiblasterEnable(TRUE);
}

static void	Printer_WriteToOutputFile(unsigned char DataByte)
{
	DigiblasterEnable(FALSE);
	if (fhPrinterOutput!=0)
	{
		BYTE Buffer[1];
		DWORD dwBytesWritten;

		Buffer[0] = DataByte;
		WriteFile(fhPrinterOutput, Buffer, sizeof(Buffer), &dwBytesWritten, NULL);
	}
}
#if 0
void	Printer_RefreshOutputs(void)
{

	switch (PrinterOutputMethod)
	{
		case PRINTER_OUTPUT_TO_FILE:
		{
			if (Printer_GetStrobeState() == 0)
			{
				/* write databyte to printer text output file */
				Printer_WriteToOutputFile(Printer_Get8BitData());
			}
		}
		break;

		case PRINTER_OUTPUT_TO_PRINTER:
		{
		}
		break;

		case PRINTER_OUTPUT_TO_DIGIBLASTER:
		{
			Audio_Digiblaster_Write(Printer_Get8BitData());
		}
		break;

		case PRINTER_OUTPUT_DO_NOTHING:
			break;
	}

}

#endif

BOOL InterfaceSavePrinter(HWND hwnd)
{
	
					OPENFILENAME	DiskImageOpenFilename;
					TCHAR			FilesOfType[256];
					FilenameBuffer[0]=_T('\0');

					//Initialize OPENFILENAME
					ZeroMemory(&DiskImageOpenFilename, sizeof(DiskImageOpenFilename));
					DiskImageOpenFilename.lStructSize = sizeof(DiskImageOpenFilename);

					{
						TCHAR *pPtr;


						pPtr = FilesOfType;

						pPtr = AppendString(pPtr, "Text files");
						pPtr = AddExtensions(pPtr, TextFileExtensions);
						pPtr = AppendChar(pPtr,_T('\0'));
						pPtr = AppendString(pPtr, Messages[28]);
						pPtr = AddExtensions(pPtr, AllFileExtensions);
						pPtr = AppendChar(pPtr,_T('\0'));
						pPtr = AppendChar(pPtr,_T('\0'));
					}

					InitFileDlg(hwnd,&DiskImageOpenFilename,_T("dsk"),FilesOfType,OFN_EXPLORER|OFN_OVERWRITEPROMPT|OFN_CREATEPROMPT);
					if (GetSaveNameFromDlg(hwnd,&DiskImageOpenFilename,NULL,Messages[2],FilenameBuffer, ""))
					{
						if (_tcslen(FilenameBuffer)!=0)
						{
							Printer_CloseOutputFile();

							PrinterOutputMethod = PRINTER_OUTPUT_TO_FILE;

							Printer_OpenOutputFile(FilenameBuffer);

							return TRUE;
						}
					}
	return FALSE;
}
#endif

//****************************************************************************************************************************

// Insert a unformatted disk image into an Amstrad drive
BOOL Interface_OpenCheatDatabase(void)
{
	OPENFILENAME	CheatDatabaseOpenFilename;
	HWND			hwnd = GetActiveWindow();
	char			FilesOfType[256];

	//Initialize OPENFILENAME
	ZeroMemory(&CheatDatabaseOpenFilename, sizeof(CheatDatabaseOpenFilename));
	CheatDatabaseOpenFilename.lStructSize = sizeof(CheatDatabaseOpenFilename);

	{
		char *pPtr;


		pPtr = FilesOfType;

		pPtr = AppendString(pPtr, Messages[71]);
		pPtr = AddExtensions(pPtr, POK_Extensions);
		pPtr = AppendChar(pPtr,_T('\0'));
		pPtr = AppendString(pPtr, Messages[28]);
		pPtr = AddExtensions(pPtr, AllFileExtensions);
		pPtr = AppendChar(pPtr,_T('\0'));
		pPtr = AppendChar(pPtr,_T('\0'));
	}


	InitFileDlg(hwnd,&CheatDatabaseOpenFilename,_T("POK"),FilesOfType,0);
	if (GetFileNameFromDlg(hwnd,&CheatDatabaseOpenFilename,NULL,Messages[24],FilenameBuffer, ""))
	{
		if (_tcslen(FilenameBuffer)!=0)
		{
			TCHAR *pDatabase;
			unsigned long DatabaseLength;

			LoadFile(FilenameBuffer, (unsigned char **)&pDatabase, &DatabaseLength);

			if (pDatabase!=NULL)
			{
				strcpy(CheatFilename, FilenameBuffer);
				// open new cheat-database
				//pCheatDatabase = CheatDatabase_Parse(pDatabase, DatabaseLength);
				WinapePokeDatabaseInit(pDatabase, DatabaseLength);

				free(pDatabase);
			}

		}

	}

	return TRUE;
}

//auto run command
void AutoRun(char * AutoTypeString)
{
	unsigned char *pBuffer = (unsigned char *)malloc(512*5);

	if (pBuffer)
		{

			/* try auto-start */
			int nAutoStartDrive = FDI_GetDriveToAccess(0);
			int nAutoStartSide = FDI_GetSideToAccess(nAutoStartDrive, 0);
			int nAutoRunResult;

			memset(pBuffer, 0x0, 512 * 5);
			nAutoRunResult = AMSDOS_GenerateAutorunCommand(nAutoStartDrive,nAutoStartSide,pBuffer,(const char **)&AutoTypeString);

			/* enable drive */
			if (!FDD_IsEnabled(nAutoStartDrive))
			{
				FDD_Enable(nAutoStartDrive, TRUE);
			}
			
			/* if inserted disk doesn't have two sides and we want to auto start on side 2 */
			if (!DiskImage_HasSide(nAutoStartDrive, 1) && (nAutoStartSide == 1))
			{

				/* forcing side 1? */
				if (FDI_GetForceSide1())
				{
					/* turn back to side 0 */
					FDI_SetForceSide1(FALSE);
				}

				/* disk turned to side B? */
				if (FDD_IsTurnDiskToSideB(nAutoStartDrive))
				{
					/* turn back to side A */
					FDD_TurnDiskToSideB(nAutoStartDrive, FALSE);
				}

				/* and auto start side 0 */
				nAutoStartSide = 0;
			}

			if (nAutoRunResult == AUTORUN_OK)
			{
 				AutoType_SetString(AutoTypeString, FALSE, TRUE, TRUE);
			}
			else
			{
				if (nAutoRunResult==AUTORUN_TOO_MANY_POSSIBILITIES)
				{
					SetInfoMessage("Too many files qualify for auto-run. Unable to auto-start this disc");
				}
				else if (nAutoRunResult==AUTORUN_NOT_POSSIBLE)
				{
					SetInfoMessage("Unable to auto-start this disc.");
				}
				else if (nAutoRunResult==AUTORUN_NO_FILES_QUALIFY)
				{
					SetInfoMessage("Can't find any files to auto-run. Unable to auto-start this disc");
				}
				else
				{
					SetInfoMessage("Unable to auto-start this disc");
				}

				/* do CAT */
				AutoType_SetString(sAutoStringCat, FALSE, TRUE, TRUE);
			}
		free(pBuffer);
	}
}

//******************************************************************************************************************

// write a snapshot
BOOL Interface_SaveSnapshot(HWND hwndParent)
{
	OPENFILENAME	SnapshotSaveFilename;
	TCHAR			FilesOfType[256];

	//Initialize OPENFILENAME
	ZeroMemory(&SnapshotSaveFilename, sizeof(SnapshotSaveFilename));
	SnapshotSaveFilename.lStructSize = sizeof(SnapshotSaveFilename);

	FilenameBuffer[0]=_T('\0');
	{
		TCHAR *pPtr;


		pPtr = FilesOfType;

		pPtr = AppendString(pPtr, Messages[38]);
		pPtr = AddExtensions(pPtr, SNA_Extensions);
		pPtr = AppendChar(pPtr,_T('\0'));
		pPtr = AppendString(pPtr, Messages[28]);
		pPtr = AddExtensions(pPtr, AllFileExtensions);
		pPtr = AppendChar(pPtr,_T('\0'));
		pPtr = AppendChar(pPtr,_T('\0'));
	}

	InitFileDlg(hwndParent,&SnapshotSaveFilename,_T("sna"),FilesOfType,OFN_EXPLORER | OFN_OVERWRITEPROMPT);
	if (GetSaveNameFromDlg(hwndParent,&SnapshotSaveFilename,NULL,Messages[14],FilenameBuffer,SnapshotPath))
	{
		if (_tcslen(FilenameBuffer)!=0)
		{
			GenericInterface_SnapshotSave(FilenameBuffer);
		}

		return TRUE;
	}

	return FALSE;
}



// write a screen snapshot
BOOL	Interface_SaveScreenSnapshot()
{
	OPENFILENAME	SnapshotSaveFilename;
	HWND			hwnd = GetActiveWindow();
	TCHAR			FilesOfType[256];

	//Initialize OPENFILENAME
	ZeroMemory(&SnapshotSaveFilename, sizeof(SnapshotSaveFilename));
	SnapshotSaveFilename.lStructSize = sizeof(SnapshotSaveFilename);

	FilenameBuffer[0]=_T('\0');
	{
		TCHAR *pPtr;


		pPtr = FilesOfType;

		pPtr = AppendString(pPtr, Messages[40]);
		pPtr = AddExtensions(pPtr, BMP_Extensions);
		pPtr = AppendChar(pPtr,_T('\0'));
		pPtr = AppendString(pPtr, Messages[28]);
		pPtr = AddExtensions(pPtr, AllFileExtensions);
		pPtr = AppendChar(pPtr,_T('\0'));
		pPtr = AppendChar(pPtr,_T('\0'));
	}

	InitFileDlg(hwnd,&SnapshotSaveFilename,_T("bmp"),FilesOfType,OFN_EXPLORER | OFN_OVERWRITEPROMPT);
	if (GetSaveNameFromDlg(hwnd,&SnapshotSaveFilename,NULL,Messages[15],FilenameBuffer,ScreenSnapshotPath))
	{

		if (_tcslen(FilenameBuffer)!=0)
		{
			GenericInterface_SaveScreenSnapshot(FilenameBuffer,FALSE);
		}

		return TRUE;
	}

	return FALSE;
}


//	CARTRIDGE
void Interface_OpenCartridge(HWND hwndParent)
{
	OPENFILENAME	CartridgeOpenFilename;
	TCHAR			FilesOfType[256];

	//check if system have cartridge reader
	//TODO

	// Initialize OPENFILENAME
    ZeroMemory(&CartridgeOpenFilename, sizeof(CartridgeOpenFilename));
	CartridgeOpenFilename.lStructSize = sizeof(CartridgeOpenFilename);

	InitFilenameForFileOpenDlg(CartridgeFilename, FilenameBuffer);

	{
		TCHAR *pPtr;

		pPtr = FilesOfType;

		pPtr = AppendString(pPtr, Messages[39]);
		pPtr = AddExtensions(pPtr, CPR_Extensions);
		pPtr = AppendChar(pPtr,_T('\0'));
		pPtr = AppendString(pPtr, Messages[28]);
		pPtr = AddExtensions(pPtr, AllFileExtensions);
		pPtr = AppendChar(pPtr,_T('\0'));
		pPtr = AppendString(pPtr, Messages[29]);
		pPtr = AddExtensions(pPtr, ZipExtensions);
		pPtr = AppendChar(pPtr,_T('\0'));
		pPtr = AppendChar(pPtr,_T('\0'));
	}

	InitFileDlg(hwndParent,&CartridgeOpenFilename,_T("cpr"),FilesOfType,OFN_EXPLORER);

	if (GetFileNameFromDlg(hwndParent,&CartridgeOpenFilename,NULL,Messages[13],FilenameBuffer,CartridgePath))
	{
		if (_tcslen(FilenameBuffer)!=0)
		{
			unsigned char *pCartridgeData;
			unsigned long CartridgeLength;
			int nStatus;

			nStatus = 0;
			
			// set the directory
			SetStringAsPath(CartridgePath, FilenameBuffer);

			
			// try to load it
			LoadFile(FilenameBuffer, &pCartridgeData, &CartridgeLength);
			
			if (pCartridgeData!=NULL)
			{
				if (Cartridge_AttemptInsert(pCartridgeData, CartridgeLength)==ARNOLD_STATUS_OK)
				{
					
					//info message
					char tmp[255];
					wsprintf(tmp,"Loading Cartridge : %s",FilenameBuffer);
					SetInfoMessage(tmp);

					//Memorise it
					strcpy(LastOpenedRom,FilenameBuffer);
					strcpy(CartridgeFilename, FilenameBuffer);

					//add to recent files
					RecentFiles_AddAndRefresh(hwndParent, FilenameBuffer, RECENT_LIST_FILES);
				}

				free(pCartridgeData);
			}
		}
	}
}

/* open a requester to load a snapshot */
void Interface_LoadSnapshot(HWND hwndParent)
{
	OPENFILENAME	SnapshotOpenFilename;
	TCHAR			FilesOfType[256];

	//Initialize OPENFILENAME
	ZeroMemory(&SnapshotOpenFilename, sizeof(SnapshotOpenFilename));
	SnapshotOpenFilename.lStructSize = sizeof(SnapshotOpenFilename);

	InitFilenameForFileOpenDlg(SnapshotFilename, FilenameBuffer);
	{
		TCHAR *pPtr;


		pPtr = FilesOfType;

		pPtr = AppendString(pPtr, Messages[38]);
		pPtr = AddExtensions(pPtr, SNA_Extensions);
		pPtr = AppendChar(pPtr,_T('\0'));
		pPtr = AppendString(pPtr, Messages[28]);
		pPtr = AddExtensions(pPtr, AllFileExtensions);
		pPtr = AppendChar(pPtr,_T('\0'));
		pPtr = AppendChar(pPtr,_T('\0'));
	}

	InitFileDlg(hwndParent,&SnapshotOpenFilename,_T("sna"),FilesOfType,OFN_EXPLORER);
	if (GetFileNameFromDlg(hwndParent,&SnapshotOpenFilename,NULL,Messages[12],FilenameBuffer,SnapshotPath))
	{
		if (_tcslen(FilenameBuffer)!=0)
		{
			unsigned char *pSnapshotData;
			unsigned long SnapshotDataLength;

			/* set the directory */
			SetStringAsPath(SnapshotPath,FilenameBuffer);

			/* try to load it */
			LoadFile(FilenameBuffer, &pSnapshotData, &SnapshotDataLength);

			if (pSnapshotData!=NULL)
			{
				SNAPSHOT_MEMORY_BLOCKS SnapshotMemoryBlocks;
				Snapshot_CollectMemory(&SnapshotMemoryBlocks, SnapshotSettings_GetDefault(), TRUE);
				if (Snapshot_Insert(pSnapshotData, SnapshotDataLength,&SnapshotMemoryBlocks)==ARNOLD_STATUS_OK)
				{
					//DS_StartSound();
					//SetString(&SnapshotFilename, pOpenFilename);
					strcpy(SnapshotFilename, FilenameBuffer);
					RecentFiles_AddAndRefresh(hwndParent, FilenameBuffer, RECENT_LIST_FILES);
				}

				free(pSnapshotData);
			}
		}
	}
}

/* open a requester to select a tape image */
void Interface_InsertTape(HWND hwndParent,BOOL bAutostart)
{
	OPENFILENAME	TapeOpenFilename;
	TCHAR			FilesOfType[256];

	//Initialize OPENFILENAME
	ZeroMemory(&TapeOpenFilename, sizeof(TapeOpenFilename));
	TapeOpenFilename.lStructSize = sizeof(TapeOpenFilename);

	InitFilenameForFileOpenDlg(TapeFilename, FilenameBuffer);

	{
		TCHAR *pPtr;


		pPtr = FilesOfType;

		pPtr = AppendString(pPtr, Messages[35]);
		pPtr = AddExtensions(pPtr, CDT_Extensions);
		pPtr = AppendChar(pPtr,_T('\0'));
		pPtr = AppendString(pPtr, Messages[36]);
		pPtr = AddExtensions(pPtr, CDTW_Extensions);
		pPtr = AppendChar(pPtr,_T('\0'));
		pPtr = AppendString(pPtr, Messages[37]);
		pPtr = AddExtensions(pPtr, CDTT_Extensions);
		pPtr = AppendChar(pPtr,_T('\0'));
		pPtr = AppendString(pPtr, Messages[28]);
		pPtr = AddExtensions(pPtr, AllFileExtensions);
		pPtr = AppendChar(pPtr,_T('\0'));
		pPtr = AppendChar(pPtr,_T('\0'));
	}

	InitFileDlg(hwndParent,&TapeOpenFilename,_T("cdt"),FilesOfType,0);
	if (GetFileNameFromDlg(hwndParent,&TapeOpenFilename,NULL,Messages[10],FilenameBuffer,TapePath))
	{
		if (_tcslen(FilenameBuffer)!=0)
		{
			unsigned char *pTapeImageData;
			unsigned long TapeImageDataSize;

			/* set the directory */
			SetStringAsPath(TapePath,FilenameBuffer);

			/* try to load it */
			LoadFile(FilenameBuffer, &pTapeImageData, &TapeImageDataSize);

			if (pTapeImageData!=NULL)
			{
				if (TapeImage_Insert(pTapeImageData, TapeImageDataSize)==ARNOLD_STATUS_OK)
				{
					if (bAutostart)
					{
						AutoType_SetString(sAutoStringTape, FALSE,TRUE, TRUE);
					}

					//SetString(&TapeFilename, pOpenFilename);
					strcpy(TapeFilename, FilenameBuffer);
					RecentFiles_AddAndRefresh(hwndParent, FilenameBuffer, RECENT_LIST_FILES);

					free(pTapeImageData);
				}
				else
				{
					free(pTapeImageData);

					if (Sample_Load(FilenameBuffer))
					{
						if (bAutostart)
						{
							AutoType_SetString(sAutoStringTape, FALSE, TRUE, TRUE);
						}

						//SetString(&TapeFilename, pOpenFilename);
						strcpy(TapeFilename, FilenameBuffer);
						RecentFiles_AddAndRefresh(hwndParent, FilenameBuffer, RECENT_LIST_FILES);

					}
				}
			}
		}
	}
}


/* open a requester to select a file */
void Interface_LoadFile(HWND hwndParent)
{
	OPENFILENAME	FileOpenFilename;
	TCHAR			FilesOfType[256];

	//Initialize OPENFILENAME
	ZeroMemory(&FileOpenFilename, sizeof(FileOpenFilename));
	FileOpenFilename.lStructSize = sizeof(FileOpenFilename);

	InitFilenameForFileOpenDlg(TapeFilename, FilenameBuffer);

	{
		TCHAR *pPtr;

		pPtr = FilesOfType;

		pPtr = AppendString(pPtr, Messages[35]);
		pPtr = AddExtensions(pPtr, BAS_Extensions);
		pPtr = AppendChar(pPtr,_T('\0'));
		pPtr = AppendString(pPtr, Messages[35]);
		pPtr = AddExtensions(pPtr, BIN_Extensions);
		pPtr = AppendChar(pPtr,_T('\0'));
		pPtr = AppendString(pPtr, Messages[28]);
		pPtr = AddExtensions(pPtr, AllFileExtensions);
		pPtr = AppendChar(pPtr,_T('\0'));
		pPtr = AppendChar(pPtr,_T('\0'));
	}

	InitFileDlg(hwndParent,&FileOpenFilename,_T("bin"),FilesOfType,0);
	if (GetFileNameFromDlg(hwndParent,&FileOpenFilename,NULL,Messages[10],FilenameBuffer,TapePath))
	{
		if (_tcslen(FilenameBuffer)!=0)
		{
			unsigned char *pFileData;
			unsigned long FileDataSize;

			/* set the directory */
			SetStringAsPath(TapePath,FilenameBuffer);

			/* try to load it */
			LoadFile(FilenameBuffer, &pFileData, &FileDataSize);

			if (pFileData!=NULL)
			{
				FILE_HEADER FileHeader;

				unsigned char *pFileDataPtr = pFileData;
                //unsigned int i;
				unsigned long Length;

				GetHeaderDataFromBuffer((const unsigned char *)pFileData, FileDataSize, &FileHeader);

				FileHeader.MemoryStart = FileHeader.HeaderStartAddress;
				Length = min(FileHeader.HeaderLength, FileDataSize);
				FileHeader.MemoryEnd = FileHeader.MemoryStart+Length;

#if 1
				/* reload system cartridge if running in cpc+ mode */
				if (CPC_GetHardware()==CPC_HW_CPCPLUS)
				{
					//CPC_ReloadSystemCartridge();
					// need to ensure the default is a system one!
					Cartridge_InsertDefault();
					//    Cartridge_Autostart();
				}

#endif
				AutoRunFile_SetData((const char *)pFileData, FileDataSize, TRUE, TRUE, &FileHeader);

                free(pFileData);
			}
		}
	}
}


/* Insert a disk image into an Amstrad drive */
void Interface_InsertDisk(HWND hwndParent, int DriveID, char * AutoTypeString, BOOL bAutostart)
{
	OPENFILENAME	DiskImageOpenFilename;
	TCHAR			FilesOfType[256];

	//Initialize OPENFILENAME
	ZeroMemory(&DiskImageOpenFilename, sizeof(DiskImageOpenFilename));
	DiskImageOpenFilename.lStructSize = sizeof(DiskImageOpenFilename);

	InitFilenameForFileOpenDlg(DriveFilenames[DriveID], FilenameBuffer);

	{
		TCHAR *pPtr;

		pPtr = FilesOfType;

		pPtr = AppendString(pPtr, Messages[23]);
		pPtr = AddExtensions(pPtr, pDiskImageReadExtensions);
		pPtr = AppendChar(pPtr,_T('\0'));
		pPtr = AppendString(pPtr,Messages[29]);
		pPtr = AddExtensions(pPtr, ZipExtensions);
		pPtr = AppendChar(pPtr,_T('\0'));
		pPtr = AppendString(pPtr, Messages[28]);
		pPtr = AddExtensions(pPtr, AllFileExtensions);
		pPtr = AppendChar(pPtr,_T('\0'));
		pPtr = AppendChar(pPtr,_T('\0'));
	}

	InitFileDlg(hwndParent,&DiskImageOpenFilename,_T("dsk"),FilesOfType,OFN_EXPLORER);
	if (GetFileNameFromDlg(hwndParent,&DiskImageOpenFilename,NULL,Messages[3],FilenameBuffer, DiskImagePath))
	{
		if (_tcslen(FilenameBuffer)!=0)
		{
			unsigned char *pDiskImage;
			unsigned long DiskImageLength;
			int nStatus;

			/* set the directory */
			SetStringAsPath(DiskImagePath, FilenameBuffer);
			
			/* if an existing disk is present then ask to save it out */
			if (FDD_IsDiskPresent(DriveID))
			{
				Interface_RemoveDisk(hwndParent,DriveID);
			}

			/* load disk image file to memory */
			LoadFile(FilenameBuffer, &pDiskImage, &DiskImageLength);

			if (pDiskImage!=NULL)
			{
				/* try to insert it */
				nStatus = DiskImage_InsertDisk(DriveID, pDiskImage, DiskImageLength);

				if (nStatus==ARNOLD_STATUS_OK)
				{

					//info message
					char tmp[255];
					wsprintf(tmp,"Loading disk : %s",FilenameBuffer);
					SetInfoMessage(tmp);

					/* add to recent */
					RecentFiles_AddAndRefresh(hwndParent, FilenameBuffer, RECENT_LIST_FILES);

					//memorise it
					if (DriveID == 0) strcpy(DriveAFilename,FilenameBuffer);
					else strcpy(DriveBFilename,FilenameBuffer);
					strcpy(LastOpenedRom,FilenameBuffer);

					/* autostart? */
					if (bAutostart) AutoRun(AutoTypeString);
				}

				free(pDiskImage);
			}
		}
	}
}


/* open a requester to select a rom */
void Interface_InsertRom(HWND hwndParent, int RomIndex)
{
	OPENFILENAME	RomOpenFilename;
	TCHAR			FilesOfType[256];

	//Initialize OPENFILENAME
	ZeroMemory(&RomOpenFilename, sizeof(RomOpenFilename));
	RomOpenFilename.lStructSize = sizeof(RomOpenFilename);

	InitFilenameForFileOpenDlg(RomFilename, FilenameBuffer);

	{
		TCHAR *pPtr;


		pPtr = FilesOfType;

		pPtr = AppendString(pPtr, Messages[33]);
		pPtr = AddExtensions(pPtr, ROM_Extensions);
		pPtr = AppendChar(pPtr,_T('\0'));
		pPtr = AppendString(pPtr, Messages[34]);
		pPtr = AddExtensions(pPtr, BIN_Extensions);
		pPtr = AppendChar(pPtr,_T('\0'));
		pPtr = AppendString(pPtr, Messages[28]);
		pPtr = AddExtensions(pPtr, AllFileExtensions);
		pPtr = AppendChar(pPtr,_T('\0'));
		pPtr = AppendChar(pPtr,_T('\0'));
	}

	InitFileDlg(hwndParent,&RomOpenFilename,_T("rom"),FilesOfType,0);
	if (GetFileNameFromDlg(hwndParent,&RomOpenFilename,NULL,Messages[7],FilenameBuffer, RomPath))
	{
		if (strlen(FilenameBuffer)!=0)
		{
			unsigned char *pRomData;
			unsigned long RomDataSize;

			/* set the directory */
			SetStringAsPath(RomPath,FilenameBuffer);

			/* try to load it */
			LoadFile(FilenameBuffer, &pRomData, &RomDataSize);

			if (pRomData!=NULL)
			{
				//ExpansionRom_SetRomData(pRomData, RomDataSize, RomIndex);

				//SetString(&RomFilename, pOpenFilename);
				//SetString(&RomFilenames[RomIndex],pOpenFilename);
				strcpy(RomFilename, FilenameBuffer);
				strcpy(RomFilenames[RomIndex],FilenameBuffer);

				free(pRomData);
			}
		}
	}
}

#if 0
/* open a requester for Multiface CPC+ rom */
void Interface_InsertMultifaceROM(HWND hwndParent,MULTIFACE_ROM_TYPE RomType)
{
	OPENFILENAME	RomOpenFilename;
	TCHAR			FilesOfType[256];

	//Initialize OPENFILENAME
	ZeroMemory(&RomOpenFilename, sizeof(RomOpenFilename));
	RomOpenFilename.lStructSize = sizeof(RomOpenFilename);

	InitFilenameForFileOpenDlg(RomFilename, FilenameBuffer);

	{
		TCHAR *pPtr;


		pPtr = FilesOfType;

		pPtr = AppendString(pPtr, Messages[33]);
		pPtr = AddExtensions(pPtr, ROM_Extensions);
		pPtr = AppendChar(pPtr,_T('\0'));
		pPtr = AppendString(pPtr, Messages[34]);
		pPtr = AddExtensions(pPtr, BIN_Extensions);
		pPtr = AppendChar(pPtr,_T('\0'));
		pPtr = AppendString(pPtr, Messages[28]);
		pPtr = AddExtensions(pPtr, AllFileExtensions);
		pPtr = AppendChar(pPtr,_T('\0'));
		pPtr = AppendChar(pPtr,_T('\0'));
	}

	InitFileDlg(hwndParent,&RomOpenFilename,_T("rom"),FilesOfType,0);
	if (GetFileNameFromDlg(hwndParent,&RomOpenFilename,NULL,Messages[8],FilenameBuffer, RomPath))
	{
		if (_tcslen(FilenameBuffer)!=0)
		{
			unsigned char *pRomData;
			unsigned long RomSize;
			int nStatus;

			nStatus = 0;
			/* set the directory */
			SetStringAsPath(RomPath,FilenameBuffer);

			/* try to load it */
			LoadFile(FilenameBuffer, &pRomData, &RomSize);

			if (pRomData!=NULL)
			{
				if (Multiface_SetRomData(RomType, pRomData, RomSize)==ARNOLD_STATUS_OK)
				{
					SetString(&RomFilename, FilenameBuffer);

					if (RomType==MULTIFACE_ROM_CPC_VERSION)
					{
						//SetString(&Multiface_CPC_ROM_Filename, pOpenFilename);
						strcpy(Multiface_CPC_ROM_Filename, FilenameBuffer);
					}
					else
					{
						//SetString(&Multiface_CPCPLUS_ROM_Filename, pOpenFilename);
						strcpy(Multiface_CPCPLUS_ROM_Filename, FilenameBuffer);
					}
				}

				free(pRomData);
			}
		}
	}

}
#endif

void Interface_RemoveDisk(HWND hwndParent,int Drive)
{
	/* has image been modified? */
	if (DiskImage_IsImageDirty(Drive))
	{
		TCHAR ImageModifiedText[128];

		_stprintf(ImageModifiedText,Messages[0],Drive);

		/* ask if we want changes to be saved.. */
		if (MessageBox(hwndParent, ImageModifiedText,Messages[1], MB_YESNO | MB_ICONQUESTION)==IDYES)
		{
			const TCHAR *sFilename;
			unsigned char *pDiskImage;
			unsigned long nDiskImage;

			sFilename = DriveFilenames[Drive];
			if (sFilename==NULL)
			{
				/* ask for filename */
				OPENFILENAME	DiskImageOpenFilename;
				TCHAR			FilesOfType[256];
				FilenameBuffer[0]=_T('\0');

				//Initialize OPENFILENAME
				ZeroMemory(&DiskImageOpenFilename, sizeof(DiskImageOpenFilename));
				DiskImageOpenFilename.lStructSize = sizeof(DiskImageOpenFilename);

				{
					TCHAR *pPtr;


					pPtr = FilesOfType;

					pPtr = AppendString(pPtr, Messages[23]);
					pPtr = AddExtensions(pPtr, pDiskImageWriteExtensions);
					pPtr = AppendChar(pPtr,_T('\0'));
					pPtr = AppendString(pPtr, Messages[28]);
					pPtr = AddExtensions(pPtr, AllFileExtensions);
					pPtr = AppendChar(pPtr,_T('\0'));
					pPtr = AppendChar(pPtr,_T('\0'));
				}

				InitFileDlg(hwndParent,&DiskImageOpenFilename,_T("dsk"),FilesOfType,OFN_EXPLORER|OFN_OVERWRITEPROMPT|OFN_CREATEPROMPT);
				if (GetSaveNameFromDlg(hwndParent,&DiskImageOpenFilename,NULL,Messages[2],FilenameBuffer, DiskImagePath))
				{
					if (_tcslen(FilenameBuffer)!=0)
					{
						sFilename = FilenameBuffer;
					}
				}
			}

			if (sFilename)
			{
				nDiskImage = DiskImage_CalculateOutputSize(Drive,FALSE);

				pDiskImage = (unsigned char *)malloc(nDiskImage);

				if (pDiskImage)
				{
					DiskImage_GenerateOutputData(pDiskImage,Drive,FALSE);

					SaveFile(sFilename, pDiskImage, nDiskImage);

					free(pDiskImage);
				}
			}
		}
	}

	DiskImage_RemoveDisk(Drive);

	//SetString(&DriveFilenames[0], NULL);
}


//***************************************************************************************************************

BOOL SaveFile(const TCHAR *pFilename, LPCVOID pLocation, unsigned long Length)
{
	BOOL fSuccess = FALSE;
	HANDLE FileHandle;

	/* attempt to open file for output

	 when writing, prevent sharing of file */
	FileHandle = CreateFile(pFilename, GENERIC_WRITE, 0, NULL, CREATE_ALWAYS, FILE_FLAG_WRITE_THROUGH, NULL);

	if (FileHandle!=INVALID_HANDLE_VALUE)
	{
		DWORD FileLengthWritten;

		if (WriteFile(FileHandle, pLocation, Length, &FileLengthWritten, NULL))
		{
			//info message
			//char tmp[255];
			//wsprintf(tmp,"Saving file : %s",pFilename);
			//SetInfoMessage(tmp);

			fSuccess = TRUE;
		}

		CloseHandle(FileHandle);

		return fSuccess;
	}

	return FALSE;
}

BOOL LoadFile(const TCHAR *pFilenameI, unsigned char **ppLocation, unsigned long *pLength)
{
	BOOL fSuccess = FALSE;
	HANDLE FileHandle;
	DWORD FileLength;
	DWORD FileLengthRead;

	//const char* lastSlash;
	char pFilename[MAX_PATH];

	*ppLocation = NULL;
	*pLength = 0;

	// attempt to open file for reading

	//zipsupport
	//lastSlash = strstr(pFilenameI, ".");
	
	if (strcmp (GetExtensionFromFilename(pFilenameI),"zip") == 0) 
	{
		GetZipExtractName(pFilenameI,pFilename,NULL);
	}
	else
	{
		strcpy(pFilename,pFilenameI);
	}

	// when reading allow sharing for reading only
	FileHandle = CreateFile(pFilename, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, FILE_FLAG_SEQUENTIAL_SCAN, NULL);

	if (FileHandle!=INVALID_HANDLE_VALUE)
	{
		/* file opened ok */

		BY_HANDLE_FILE_INFORMATION FileInformation;

		if (GetFileInformationByHandle(FileHandle, &FileInformation))
		{
			/* got file information */
			FileLength = FileInformation.nFileSizeLow;

			/* if file is not zero size */
			if ((FileInformation.nFileSizeLow | FileInformation.nFileSizeHigh)!=0)
			{
				void	*pFileMemory;

				/* allocate */
				pFileMemory = (void *)malloc(FileLength);

				if (pFileMemory!= NULL)
				{
					/* load */
					if (ReadFile(FileHandle, (LPVOID)pFileMemory, FileLength, &FileLengthRead, NULL))
					{

						*ppLocation = (unsigned char *)pFileMemory;
						*pLength = FileLength;

						fSuccess = TRUE;
					}

					if (!fSuccess)
						free(pFileMemory);
				}

			}
		}

		CloseHandle(FileHandle);
	}

	return fSuccess;
}
/*-------------------------------------------------------------------------------------------------------------------*/
#if 0
void GetHeaderDataFromBuffer(const unsigned char *pFileData, unsigned long FileDataSize, FILE_HEADER *pFileHeader)
{
	pFileHeader->bHasHeader = FALSE;
	pFileHeader->MemoryStart = 0;
	pFileHeader->MemoryEnd = FileDataSize;

	if (AMSDOS_HasAmsdosHeader(pFileData))
	{
		AMSDOS_HEADER *pHeader = (AMSDOS_HEADER *)pFileData;

		/* fetch file type */
		pFileHeader->HeaderFileType = pHeader->FileType;

		/* get length reported by header */
		pFileHeader->HeaderLength = ((pHeader->DataLengthLow&0x0ff) | ((pHeader->DataLengthMid&0x0ff)<<8) | ((pHeader->DataLengthHigh&0x0ff)<<16));

		/* fetch start address from header */
		pFileHeader->HeaderStartAddress = ((pHeader->LocationLow & 0x0ff) | ((pHeader->LocationHigh & 0x0ff)<<8));

		pFileHeader->HeaderExecutionAddress = ((pHeader->ExecutionAddressLow & 0x0ff) | ((pHeader->ExecutionAddressHigh & 0x0ff)<<8));

		pFileHeader->bHasHeader = TRUE;
	}
	else
	{
		/* fill in dummy values */
		pFileHeader->HeaderFileType = 2;

		pFileHeader->HeaderStartAddress = 0;

		pFileHeader->HeaderLength = FileDataSize;

		pFileHeader->HeaderExecutionAddress = pFileHeader->HeaderStartAddress;
	}
}
#endif